#!/bin/bash

set -e



# Check prerequisites

if [ ! -f kernel_images/bzImage ] || [ ! -f kernel_images/initramfs.cpio.gz ]; then

echo "ERROR: Missing bzImage or initramfs.cpio.gz in kernel_images/ directory."

echo "Please supply your Linux kernel and ramdisk before building."

exit 1

fi



echo "--- 1. Building HDGL Bootloader (Bare-Metal C) ---"

cd bootloader

xxd -i ../kernel_images/bzImage > kernel.h

xxd -i ../kernel_images/initramfs.cpio.gz > initramfs.h



# Compile using freestanding and nostdlib to get a raw bootable binary

x86_64-linux-gnu-gcc \

-ffreestanding -O2 -nostdlib \

hdgl_bootloader.c -o hdgl_bootloader.bin

echo "Bootloader build SUCCESS: bootloader/hdgl_bootloader.bin"



echo "--- 2. Building Kernel Module and Interpreter ---"

cd ../kernel_module



# Build the kernel module (.ko)

make -f Makefile

echo "Kernel Module build SUCCESS: hdgl_lattice_sysfs.ko"



# Build the user-space interpreter

gcc hdgl_bin_interpreter.c -o hdgl_interpreter -lm

echo "Interpreter build SUCCESS: hdgl_interpreter"



cd ..

echo "--- ALL HDGL STACK COMPONENTS BUILT ---"

echo "Ready for deployment via QEMU."